chrome.tabs.query({active: true, currentWindow: true}, (tabs) => {
    const tab = tabs[0];
    if (tab && tab.url && tab.url.includes("youtube.com/watch")) {
        const urlParams = new URLSearchParams(new URL(tab.url).search);
        const videoId = urlParams.get("v");
        if (videoId) {
            const imgUrl = `https://img.youtube.com/vi/${videoId}/maxresdefault.jpg`;
            document.getElementById('preview').src = imgUrl;
            document.getElementById('dl-btn').onclick = () => chrome.tabs.sendMessage(tab.id, {action: "download", url: imgUrl, id: videoId});
            document.getElementById('copy-btn').onclick = () => chrome.tabs.sendMessage(tab.id, {action: "copy", url: imgUrl});
        }
    } else {
        document.getElementById('content').innerHTML = `<div style="padding: 20px; color: #aaa;">Open a YouTube video to use this tool.<div class="footer">Developed by <strong>Tim Verdouw</strong></div></div>`;
    }
});